
<?php
// Start a session
session_start();

// Database connection
include "../connection.php"; 

// Check if the user is logged in
if (!isset($_SESSION['userid'])) {
    header("Location: ../login.php");
    exit();
}


$userid = $_SESSION['userid'];



$sql = "SELECT s.username, s.number, COALESCE(b.amount, 0) AS amount FROM student s
        LEFT JOIN balance b ON s.userid = b.userid
        WHERE s.userid = ?";
$stmt = $con->prepare($sql);

if (!$stmt) {
    die("Query preparation failed: " . $con->error);
}

$stmt->bind_param("s", $userid);
$stmt->execute();
$result = $stmt->get_result();

// Fetch user data and balance
if ($row = $result->fetch_assoc()) {
    $username = htmlspecialchars($row['username']); // Sanitize output
    $number = htmlspecialchars($row['number']);     // Sanitize output
    $amount = htmlspecialchars($row['amount']);     // Sanitize output
} else {
    // Since we are using LEFT JOIN, this block should not execute anymore.
    echo "User data not found.";
    exit();
}

// Close connection
$stmt->close();
$con->close();
?>


	
    <!-- Navigation Menu -->
	<?php include 'header-link.php' ?>

    <main>
	
        <?php include 'top-bar.php' ?>
		
		<section>   <!-- Info Tab -->
            <div>
                    <div class="container name-balnc">
                        <div class="row w-100">
                            <div class="col-7">
                                <div class="name-text">
                                    <h5 class="mb-3"> <i class="info-font fa-duotone fa-solid fa-user mx-2"></i>  <?php echo htmlspecialchars($username); ?> </h5>  <hr>   
                                    <h6> <i class="info-font fa-duotone fa-solid fa-phone mx-2"></i>  <?php echo htmlspecialchars($number); ?> </h6>                   
                                    
                                </div>
                                
                            </div>
							
							<div class="col-5">
                                
									<div class="amt-round">
										<div class="amt-text">
											<a href="index.php" style="font-size:20px;font-weight:500;color:;"><?php echo htmlspecialchars(number_format($amount)); ?> ৳  </a> 
											<br> <small style="color:;">বর্তমান ব্যালেন্স</small>
										</div>
									</div>
                            </div>
							
							
                        </div>
                    </div>
            </div>

        </section>  <!-- Info Tab -->


        <section>   <!-- Info Tab -->
           
                    <div class="container text-center">
                        <div class="row w-75 text-center justify-content-center">
                        
                            <div class="toast my-5" id="toast"><?php
                                    if (isset($_SESSION['message'])) {
                                        echo $_SESSION['message'];
                                        unset($_SESSION['message']); // Clear the message after displaying
                                    }?>
                                </div>

                           
                        </div>
                    </div>
          

        </section>  <!-- Info Tab -->

        <section>   <!-- Info Tab -->
            <div class="info-tab" style="margin-bottom: 150px;">
                    <div class="container text-center">
                        <div class="row w-100 text-center">
						
						
                            <div class="col-4 my-3">
                                <a href="balance-add.php" class="nav-link info-tab-item" title="এ্যাড ব্যালেন্স"><i class="info-font fa-duotone fa-solid fa-wallet "></i> <br>  এ্যাড ব্যালেন্স   - অটো  </a>
                            </div>
							
							 <div class="col-4 my-3">
                                <a href="manual-balance-add.php" class="nav-link info-tab-item" title="এ্যাড ব্যালেন্স"><i class="info-font fa-sharp-duotone fa-solid fa-forklift"></i> <br> এ্যাড ব্যালেন্স - ম্যানুয়াল  </a>
                            </div>
							
							
                            <div class="col-4 my-3">
                                <a href="top-up-w.php" class="nav-link info-tab-item " title="টপ-আপ"><i class="info-font fa-duotone fa-solid fa-mobile-button"></i> <br> টপ-আপ </a>
                            </div>
							
							<hr style="width:87%;margin:0 auto;">

                            <div class="col-4 my-3">
                                <a href="mobile-banking-w.php" class="nav-link info-tab-item " title="মোবাইল ব্যাংকিং"><i class="info-font fa-regular fa-mobile-signal "></i> <br> মোবাইল ব্যাংকিং </a>
                            </div>
							
							
							
                            <div class="col-4 my-3">
                                <a href="banking-w.php" class="nav-link info-tab-item " title="ব্যাংকিং"><i class="info-font fa-solid fa-building-columns "></i> <br> ব্যাংকিং  সেবা </a>
                            </div>

                            <div class="col-4 my-3">
                                <a href="bill-pay-w.php" class="nav-link info-tab-item " title="বিল পে"><i class="info-font fa-light fa-money-check-dollar-pen "></i><br> বিল পে </a>
                            </div>
							
							<hr style="width:87%;margin:0 auto;">
							
							<div class="col-4 my-3">
                                <a href="drive-list.php" class="nav-link info-tab-item " title=" ড্রাইভ অফার "><i class="info-font fa-solid fa-gift "></i><br> ড্রাইভ অফার </a>
                            </div>
							
							
							
							<div class="col-4 my-3">
                                <a href="package-list.php" class="nav-link info-tab-item " title="প্যাকেজ রিচার্জ"><i class="info-font fa-solid fa-gifts "></i><br> প্যাকেজ রিচার্জ </a>
                            </div>
							
							<div class="col-4 my-3">
                                <a href="money-saving.php" class="nav-link info-tab-item " title="মানি সেভিং"><i class="info-font fa-duotone fa-solid fa-vault "></i><br> মানি সেভিং </a>
                            </div>
							
							<hr style="width:87%;margin:0 auto;">
							
							<div class="col-4 my-3">
                                <a href="trans-history.php" class="nav-link info-tab-item " title="ট্রান্জেকশন হিস্টোরি"><i class="info-font fa-regular fa-rectangle-history-circle-plus"></i><br> ট্রান্জেকশন হিস্টোরি </a>
                            </div>
							
							
							
							<div class="col-4 my-3">
                                <a href="reseller-reg.php" class="nav-link info-tab-item " title="রেজিস্ট্রেশন"><i class="info-font fa-solid fa-user-plus "></i><br> রেজিস্ট্রেশন </a>
                            </div>
							
							<div class="col-4 my-3">
                                <a href="reseller-list.php" class="nav-link info-tab-item " title="আমার রিসেলার"><i class="info-font fa-solid fa-users "></i><br> আমার রিসেলার </a>
                            </div>
							
							<hr style="width:87%;margin:0 auto;">
							
							<div class="col-4 my-3">
                                <a href="reseller-list.php" class="nav-link info-tab-item " title="সেন্ড মানি - রিসেলার"><i class="info-font fa-duotone fa-solid fa-paper-plane "></i><br> সেন্ড মানি - রিসেলার </a>
                            </div>
							
							<div class="col-4 my-3">
                                <a href="money-rate.php" class="nav-link info-tab-item " title="টাকা রেট "><i class="info-font fa-solid fa-money-bill-trend-up"></i><br> আজকের টাকা রেট </a>
                            </div>
							
							<div class="col-4 my-3">
                                <a href="bank-address.php" class="nav-link info-tab-item " title="ব্যাংক হিসাব সমূহ "><i class="info-font fa-duotone fa-solid fa-money-check-dollar-pen"></i><br> ব্যাংক হিসাব সমূহ </a>
                            </div>
							
							<hr style="width:87%;margin:0 auto;">
							
							
							

                            <div class="col-4 my-3">
                                <a href="work-ongoing.php" class="nav-link info-tab-item " title="অ্যাডমিন  চ্যাট"><i class="info-font fa-brands fa-whatsapp "></i><br> অ্যাডমিন সাপোর্ট </a>
                            </div>

                           
                        </div>
                    </div>
            </div>

        </section>  <!-- Info Tab -->


    </main>
    <script>
    window.onload = function() {
        var toast = document.getElementById("toast");
        if (toast.innerHTML) {
            toast.className = "toast show";
            setTimeout(function() {
                toast.className = toast.className.replace("show", "");
            }, 3000); // Show toast for 3 seconds
        }
    };
</script>
    
</body>
</html>
